#define USEFOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
float4 worldEye : register (c8);
float4 fogData : register (c9);
float4 dirLight : register (c14);

#if OMNI == 1

float4 omniPosRad[12]   : register (c72);
float4 omniRGBDelta[12] : register (c84);

#elif SPOT == 1

float4 spotPosRad[4]    : register (c72);
float4 spotRGBDelta[4]  : register (c80);
float4 spotDirCone[4]   : register (c88);

#endif

struct VS_OUTPUT
{
   float4 Pos   : POSITION;
   float4 Diff  : COLOR0;
   float4 Omni  : COLOR1;
#ifdef USEFOG
   float  Fog   : FOG;
#endif   
   float2 Tex0  : TEXCOORD0;
 #if NUMTEX == 2
   float2 Tex1  : TEXCOORD1;
 #endif  
   float3 Light : TEXCOORD2;
   float2 Bump  : TEXCOORD3;
};

#if OMNI == 1

 #if NUMTEX == 1
  VS_OUTPUT vs11_blinnBumpOmniT0 (float4 inPos : POSITION, float3 inNorm : NORMAL, float4 inColor : COLOR0, float4 inTangent : TANGENT, float4 inBiNorm : BINORMAL, float2 inTex0 : TEXCOORD0, float2 inBump : TEXCOORD3)
 #elif NUMTEX == 2
  VS_OUTPUT vs11_blinnBumpOmniT0T1 (float4 inPos : POSITION, float3 inNorm : NORMAL, float4 inColor : COLOR0, float4 inTangent : TANGENT, float4 inBiNorm : BINORMAL, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inBump : TEXCOORD3)
 #endif
  
#elif SPOT == 1

 #if NUMTEX == 1
  VS_OUTPUT vs11_blinnBumpSpotT0 (float4 inPos : POSITION, float3 inNorm : NORMAL, float4 inColor : COLOR0, float4 inTangent : TANGENT, float4 inBiNorm : BINORMAL, float2 inTex0 : TEXCOORD0, float2 inBump : TEXCOORD3)
 #elif NUMTEX == 2
  VS_OUTPUT vs11_blinnBumpSpotT0T1 (float4 inPos : POSITION, float3 inNorm : NORMAL, float4 inColor : COLOR0, float4 inTangent : TANGENT, float4 inBiNorm : BINORMAL, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inBump : TEXCOORD3)
 #endif
  
#else

 #if NUMTEX == 1
  VS_OUTPUT vs11_blinnBumpT0 (float4 inPos : POSITION, float3 inNorm : NORMAL, float4 inColor : COLOR0, float4 inTangent : TANGENT, float4 inBiNorm : BINORMAL, float2 inTex0 : TEXCOORD0, float2 inBump : TEXCOORD3)
 #elif NUMTEX == 2
  VS_OUTPUT vs11_blinnBumpT0T1 (float4 inPos : POSITION, float3 inNorm : NORMAL, float4 inColor : COLOR0, float4 inTangent : TANGENT, float4 inBiNorm : BINORMAL, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1, float2 inBump : TEXCOORD3)
 #endif 
  
#endif
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space:
  Out.Pos = mul (viewProjMatrix, inPos);
  float3 worldPos = mul (worldMatrix, inPos);

  float3 worldS;
  float3 worldT;
  float3 worldSxT;
  worldS.xyz = mul (worldMatrix, inTangent.xyz);
  worldT.xyz = mul (worldMatrix, inBiNorm.xyz);
  worldSxT.xyz = mul (worldMatrix, inNorm.xyz);
  
  Out.Light.x = dot (dirLight.xyz, worldS.xyz);
  Out.Light.y = dot (dirLight.xyz, worldT.xyz);
  Out.Light.z = dot (dirLight.xyz, worldSxT.xyz);
  
#ifdef USEFOG
  // compute fog
  float3 eyeVec = worldPos + worldEye.xyz;
  Out.Fog.x = (fogData[1] - (length (eyeVec.xyz) * fogData[0]));
#endif   
  
#if OMNI == 1
  // Compute omnilights
  Out.Omni = (0,0,0,0);
  Out.Omni.a = inColor.a;
  
  float3 worldNorm = mul (worldMatrix, inNorm.xyz);
  for (int i=0; i<6; i++)
  {
    float intens;
    float3 omniToVert = omniPosRad[i].xyz - worldPos.xyz;
    float mag = dot (omniToVert.xyz, omniToVert.xyz);
    // check if vert in range
    if ( mag < omniPosRad[i].w) // using square distances
      if ((intens = dot (worldNorm, normalize (omniToVert))) > 0) // check backface
        Out.Omni.rgb += (sqrt(intens) * omniRGBDelta[i].rgb * (1.0F - (sqrt(mag) * omniRGBDelta[i].w)));
  }
  
#elif SPOT == 1

  // Compute spotlights
  float4 spotColor = (0,0,0,1);
  float3 worldNorm = mul (worldMatrix, inNorm.xyz);
  //for (int i=0; i<numActive.y; i++)
  for (int i=0; i<4; i++)
  {
    // check backface
    if (dot (worldNorm, spotDirCone[i].xyz) <= 0)
    {
      float3 spotToVert = worldPos.xyz - spotPosRad[i].xyz;
      float mag = dot (spotToVert.xyz, spotToVert.xyz);
      // check if vert in range
      if (mag < spotPosRad[i].w) // using square distances
      {
        // check if vert in cone
        mag = dot (normalize (spotToVert.xyz), spotDirCone[i].xyz);
        if (mag > spotDirCone[i].w)
        {
          float intensity = (1.0F - ( sqrt (mag) * spotRGBDelta[i].w));
          spotColor.rgb += (spotRGBDelta[i].rgb * intensity);
        }  
      }
    }
  }
  Out.Omni = spotColor;

#else

  Out.Omni = 0;

#endif

  // Propagate color and texture coordinates:
  Out.Diff = inColor;
  Out.Tex0 = inTex0;
 #if NUMTEX == 2
  Out.Tex1 = inTex1;
 #endif 
  Out.Bump = inBump;

  return (Out);
}
